
package simplesvm;

import java.util.*;

public class ImplicitHashMap implements Map, java.io.Serializable {
    
    private static final int[] bases = { 31, 15, 53, 19, 71 };

    private HashMap top;
    private int nlevels;

    private int size = 0;

    public ImplicitHashMap(int nlevels) {
	this.nlevels = nlevels;
	top = new HashMap();
    }

    public Object put(Object key, Object value) {
	if(!(key instanceof String))
	    throw new IllegalArgumentException("Only strings can be keys.");
	if(value == null)
	    throw new NullPointerException("Null values not supported.");
	
	String ks = (String) key;
	HashMap m = top;
	int depth = 0;
	while(depth < nlevels - 1) {
	    Integer h = new Integer(stringHash(ks, bases[depth]));
	    HashMap m2 = (HashMap) m.get(h);
	    if(m2 == null) {
		m2 = new HashMap(1);
		m.put(h, m2);
	    }
	    m = m2;
	    depth++;
	}
	Integer h = new Integer(stringHash(ks, bases[depth]));
	Object old = m.put(h, value);
	if(old == null)
	    size += 1;
	return old;
    }

    public Object get(Object key) {
	if(!(key instanceof String))
	    throw new IllegalArgumentException("Only strings can be keys.");
	String ks = (String) key;
	HashMap m = top;
	int depth = 0;
	while(depth < nlevels - 1 && m != null) {
	    Integer h = new Integer(stringHash(ks, bases[depth]));
	    m = (HashMap) m.get(h);
	    depth++;
	}
	if(m == null)
	    return null;
	Integer h = new Integer(stringHash(ks, bases[depth]));
	return m.get(h);
    }

    private int stringHash(String s, int base) {
	int l = s.length();
	int sum = 0;
	for(int i = 0; i < l; i++) {
	    sum *= base;
	    sum += s.charAt(i);
	}
	return sum;
    }

    public int size() {
	return size;
    }

    public void clear() {
	top.clear();
    }

    public Object remove(Object o) {
	throw new UnsupportedOperationException("Not implemented");
    }

    public Set keySet() {
	throw new UnsupportedOperationException("Not implemented");
    }

    public Set entrySet() {
	throw new UnsupportedOperationException("Not implemented");
    }

    public void putAll(Map m) {
	throw new UnsupportedOperationException("Not implemented");
    }

    public Collection values() {
	throw new UnsupportedOperationException("Not implemented");
    }

    public boolean containsValue(Object o) {
	throw new UnsupportedOperationException("Not implemented");
    }

    public boolean containsKey(Object o) {
	throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isEmpty() {
	return top.isEmpty();
    }
    
}
