find_package(UNITTESTCHECK REQUIRED)


INCLUDE_DIRECTORIES(
  ${UNITTESTCHECK_INCLUDE_DIR} 
)

#set_source_files_properties(
#    rip2lib.c
#    rip_proc.c
#    PROPERTIES
#    COMPILE_FLAGS "--coverage"
#)

enable_testing()

add_library(unittest_rip SHARED 
    test/unit/rip2lib/main.c 
    test/unit/rip2lib/rip2lib.c
)
target_link_libraries(unittest_rip riplib)

add_library(unittest_procrip SHARED 
    test/unit/proc_rip/main.c 
    test/unit/proc_rip/proc_rip.c
    rip_proc_generic.c
)
target_link_libraries(unittest_procrip riplib)

set_target_properties(
    unittest_rip
    unittest_procrip 
    PROPERTIES
    LINK_FLAGS --coverage
    COMPILE_DEFINITIONS USERSPACE
)

add_test (RipUnitTests ${UNITTESTCHECK_BINARY} --nf --nml unittest_rip)
add_test (RipProcTests ${UNITTESTCHECK_BINARY} --nf --nml unittest_procrip)

